

/*
*  ESP32 WiFi Scanner Example. Examples > WiFi > WiFiScan
*  Full Tutorial @ https://deepbluembedded.com/esp32-wifi-library-examples-tutorial-arduino/
*/
 
#include "WiFi.h"
 // Turns the 'PRG' button into the power button, long press is off 
#define HELTEC_POWER_BUTTON   // must be before "#include <heltec_unofficial.h>"
#include <heltec_unofficial.h>
// This file contains binary patch for the SX1262
#include "modules/SX126x/patches/SX126x_patch_scan.h"
void setup()
{
    heltec_setup();
    Serial.begin(115200);
 
    // Set WiFi to station mode and disconnect from an AP if it was previously connected.
    WiFi.mode(WIFI_STA);
    WiFi.disconnect();
    delay(100);
 
    both.println("Setup done");
}
 
void loop()
{
    both.println("Scan start");
 
    // WiFi.scanNetworks will return the number of networks found.
    int n = WiFi.scanNetworks();
    both.println("Scan done");
    if (n == 0) {
        both.println("no networks found");
    } else {
        both.print(n);
        both.println(" networks found");
        both.println("Nr | SSID                             | RSSI | CH | Encryption");
        for (int i = 0; i < n; ++i) {
            // Print SSID and RSSI for each network found
            both.printf("%2d",i + 1);
            both.print(" | ");
            both.printf("%-32.32s", WiFi.SSID(i).c_str());
            both.print(" | ");
            both.printf("%4d", WiFi.RSSI(i));
            both.print(" | ");
            both.printf("%2d", WiFi.channel(i));
            both.print(" | ");
            switch (WiFi.encryptionType(i))
            {
            case WIFI_AUTH_OPEN:
                both.print("open");
                break;
            case WIFI_AUTH_WEP:
                both.print("WEP");
                break;
            case WIFI_AUTH_WPA_PSK:
                both.print("WPA");
                break;
            case WIFI_AUTH_WPA2_PSK:
                both.print("WPA2");
                break;
            case WIFI_AUTH_WPA_WPA2_PSK:
                both.print("WPA+WPA2");
                break;
            case WIFI_AUTH_WPA2_ENTERPRISE:
                both.print("WPA2-EAP");
                break;
            case WIFI_AUTH_WPA3_PSK:
                both.print("WPA3");
                break;
            case WIFI_AUTH_WPA2_WPA3_PSK:
                both.print("WPA2+WPA3");
                break;
            case WIFI_AUTH_WAPI_PSK:
                both.print("WAPI");
                break;
            default:
                both.print("unknown");
            }
            both.println();
            delay(10);
        }
    }
    both.println("");
 
    // Delete the scan result to free memory for code below.
    WiFi.scanDelete();
    
    // Wait a bit before scanning again.
    delay(5000);
}