
#include <WiFi.h>

// Turns the 'PRG' button into the power button, long press is off 
#define HELTEC_POWER_BUTTON   // must be before "#include <heltec_unofficial.h>"
#include <heltec_unofficial.h>
// This file contains binary patch for the SX1262
#include "modules/SX126x/patches/SX126x_patch_scan.h"

// Replace with your network credentials
const char* ssid     = "ESAP32";
const char* password = "Esp32-ap";

// Set web server port number to 80
WiFiServer server(80);

void setup() {
  heltec_setup();
  Serial.begin(115200);
  // Connect to Wi-Fi network with SSID and password
  both.println("STARTING AP");
  both.println("STARTED AP");
  both.print("AP: ");
  both.println(ssid);
  both.print("PW: ");
  both.println(password);
  //both.println();both.print(ssid);
  // Remove the password parameter, if you want the AP (Access Point) to be open
  WiFi.softAP(ssid,password);

  IPAddress IP = WiFi.softAPIP();
  both.print("IP: ");
  both.println(IP);
  server.begin();
}

void loop(){
   WiFiClient client = server.available();   // Listen for incoming clients

  if (client) {                             // If a new client connects,
    both.println("CLIENT CONNECTED");          // print a message out in the serial port
    client.println("CLIENT CONNECTED");
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        both.write(c);                    // print it out the serial monitor
        client.write(c);
        currentLine += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 2) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();

            // Send your "Hello World" HTML response
            client.println("<html><head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"></head>");
            client.println("<body><h1>ESAP32</h1></body></html>");

            // The HTTP response ends with another blank line
            client.println("ESAP32 NET");
            client.println(c); 
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Close the connection
    client.stop();
    both.println("CLIENT DISCONNECTED");
    client.println("CLIENT DISCONNECTED");
    both.println("");
  }
}